/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax;

import cnrg.itx.datax.devices.*;
/**
 * Class to represent an audio connection.
 */
public class AudioConnection extends Connection
{
	/**
	 * Creates the default AudioConnection object input channel. The default
	 * audio connection has an input channel and an output channel. The input
	 * channel has a network destination as the source and the speaker as the
	 * destination and the input channel has the microphone as the source and
	 * the network destination as the destination.
	 * @exception DataException thrown when a default audio connection cannot be made
	 */
	public static AudioConnection getDefaultAudioConnection() throws DataException
	{
		Channel cInput = new Channel();
		Channel cOutput = new Channel();
		
		cInput.setSource(new NetworkSource( cInput, Channel.SAMPLE_SIZE ));
		cInput.addDestination (new SpeakerDestination() );
		
		cOutput.setSource( new MicrophoneSource(cOutput) );
		cOutput.addDestination (new NetworkDestination () );

		return new AudioConnection(cInput, cOutput);
	}

	/**
	 * Creates a connection object
	 * @param input the new input channel
	 * @param output the new output channel.
	 */
	public AudioConnection(Channel input, Channel output)
	{
		super (input, output);
	}
}
